/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.logger;

import io.gitlab.jfronny.commons.logger.DelegateLogger;
import io.gitlab.jfronny.commons.logger.LeveledLoggerFinder;
import io.gitlab.jfronny.commons.logger.LoggerConfiguration;
import io.gitlab.jfronny.commons.logger.StdoutLogger;
import io.gitlab.jfronny.commons.logger.SystemLoggerPlus;
import io.gitlab.jfronny.commons.ref.WeakSet;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class HotswapLoggerFinder
extends LeveledLoggerFinder {
    private static final Set<HotswapLoggerFinder> KNOWN_INSTANCES = new WeakSet<HotswapLoggerFinder>();
    private static LeveledLoggerFinder DEFAULT_FACTORY = StdoutLogger.FANCY;
    private static System.Logger.Level DEFAULT_LEVEL = System.Logger.Level.INFO;
    private LeveledLoggerFinder defaultFactory = DEFAULT_FACTORY;
    private System.Logger.Level minimumLevel = DEFAULT_LEVEL;
    private int version = 0;

    public static void resetAllStrategies() {
        HotswapLoggerFinder.updateAllStrategies(StdoutLogger.FANCY);
    }

    public static void updateAllStrategies(System.LoggerFinder factory) {
        HotswapLoggerFinder.updateAllStrategies(LeveledLoggerFinder.get(factory));
    }

    public static void updateAllStrategies(LeveledLoggerFinder.Simple factory) {
        HotswapLoggerFinder.updateAllStrategies(LeveledLoggerFinder.get(factory));
    }

    public static void updateAllStrategies(LeveledLoggerFinder factory) {
        DEFAULT_FACTORY = Objects.requireNonNull(factory);
        for (HotswapLoggerFinder f : KNOWN_INSTANCES) {
            f.updateStrategy(factory);
        }
    }

    public static void updateAllDefaultLevels(System.Logger.Level minimumLevel) {
        DEFAULT_LEVEL = Objects.requireNonNull(minimumLevel);
        for (HotswapLoggerFinder f : KNOWN_INSTANCES) {
            f.updateDefaultLevel(minimumLevel);
        }
    }

    public HotswapLoggerFinder() {
        KNOWN_INSTANCES.add(this);
    }

    public void resetStrategy() {
        this.updateStrategy(StdoutLogger::fancy);
    }

    public void updateStrategy(System.LoggerFinder factory) {
        if (factory instanceof LeveledLoggerFinder) {
            LeveledLoggerFinder f = (LeveledLoggerFinder)factory;
            this.updateStrategy(f);
        } else {
            this.updateStrategy(LeveledLoggerFinder.get(factory));
        }
    }

    public void updateStrategy(LeveledLoggerFinder.Simple factory) {
        this.updateStrategy(LeveledLoggerFinder.get(factory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStrategy(LeveledLoggerFinder factory) {
        HotswapLoggerFinder hotswapLoggerFinder = this;
        synchronized (hotswapLoggerFinder) {
            this.defaultFactory = Objects.requireNonNull(factory);
            ++this.version;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDefaultLevel(System.Logger.Level minimumLevel) {
        HotswapLoggerFinder hotswapLoggerFinder = this;
        synchronized (hotswapLoggerFinder) {
            this.minimumLevel = Objects.requireNonNull(minimumLevel);
            ++this.version;
        }
    }

    @Override
    public SystemLoggerPlus getLogger(String name, Module module, @Nullable System.Logger.Level level) {
        return new SwappableDelegateLogger(name, module, level);
    }

    static {
        try {
            ServiceLoader.load(LoggerConfiguration.class).forEach(LoggerConfiguration::configure);
        }
        catch (Throwable t) {
            System.err.println("Could not initialize LoggerConfiguration");
            t.printStackTrace();
        }
    }

    private class SwappableDelegateLogger
    extends DelegateLogger {
        private final String name;
        private final Module module;
        private final boolean keepLevel;
        private System.Logger.Level lastMinimumLevel;
        private System.Logger delegate;
        int version = -1;

        private SwappableDelegateLogger(String name, @Nullable Module module, System.Logger.Level level) {
            this.name = name == null ? "null" : name;
            this.module = module;
            this.keepLevel = level != null;
            this.lastMinimumLevel = level == null ? HotswapLoggerFinder.this.minimumLevel : level;
            this.updateStrategy();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateStrategy() {
            if (this.version == HotswapLoggerFinder.this.version) {
                return;
            }
            HotswapLoggerFinder hotswapLoggerFinder = HotswapLoggerFinder.this;
            synchronized (hotswapLoggerFinder) {
                this.version = HotswapLoggerFinder.this.version;
                if (!this.keepLevel) {
                    this.lastMinimumLevel = HotswapLoggerFinder.this.minimumLevel;
                }
                this.delegate = HotswapLoggerFinder.this.defaultFactory.getLogger(this.name, this.module, this.lastMinimumLevel);
            }
        }

        @Override
        protected System.Logger getDelegate() {
            this.updateStrategy();
            return this.delegate;
        }
    }
}

